package com.burhanstore.neonbubblequest

import android.app.Activity
import android.content.Intent
import android.os.Bundle
import android.util.Log
import android.widget.Toast
import androidx.appcompat.app.AppCompatActivity
import androidx.lifecycle.lifecycleScope
import com.burhanstore.neonbubblequest.Utils.AppString.getAndroidId
import com.burhanstore.neonbubblequest.Utils.AppString.getFcmToken
import com.burhanstore.neonbubblequest.Utils.anim.AnimationHelper
import com.burhanstore.neonbubblequest.Utils.appuser.UserManager
import com.burhanstore.neonbubblequest.Utils.network.AppNetworkAdapter
import com.burhanstore.neonbubblequest.Utils.response.SplashResponse
import com.burhanstore.neonbubblequest.act.LoginActivity
import com.burhanstore.neonbubblequest.databinding.ActivitySplashBinding
import com.google.gson.Gson
import com.google.gson.JsonObject
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch
import kotlinx.coroutines.withContext

class SplashActivity : AppCompatActivity() {
    private lateinit var binding: ActivitySplashBinding
    private lateinit var user_m: UserManager
    private lateinit var activity: Activity

    var f_token: String? = null


    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        binding = ActivitySplashBinding.inflate(layoutInflater)
        setContentView(binding.root)
        activity = this


        user_m = UserManager.getInstance(activity)
        getFcmToken { token ->
            if (token.isNotEmpty()) {
                println("FCM Token: $token")
                f_token = token
            }
        }


        splash_data()


    }


    private fun splash_data() {

        val json = JsonObject().apply {
            addProperty("action", "splash")
            addProperty("fcm_token", f_token)
            addProperty("android_id", getAndroidId(activity))
        }

        AppNetworkAdapter.sendRequest(
            lifecycleScope,
            json,
            object : AppNetworkAdapter.ResponseHandler {
                override fun onSuccess(response: JsonObject?) {
                    Log.d("SplashActivity", "Success: $response")

                    lifecycleScope.launch {
                        val signupResponse = Gson().fromJson(response, SplashResponse::class.java)
                        val user = signupResponse.user
                        val setting = signupResponse.setting
                        if (user != null) {
                            user_m.saveUser(user)
                            user_m.saveSetting(setting)

                            AppConst.setString(
                                activity, AppConst.USER_COIN,
                                user_m.getUser()?.point ?: "0"
                            )
                            withContext(Dispatchers.Main) {
                                val intent = Intent(activity, MainActivity::class.java)
                                startActivity(intent)
                                AnimationHelper.applySlideZoomTransition(activity)
                                finish()
                            }

                        }
                    }


                }

                override fun onError(code: Int, message: String?) {
                    Log.e("SplashActivity", "Error $code: $message")

                    login_open()


                    //  Toast.makeText(this@SplashActivity, "Error: $code", Toast.LENGTH_SHORT).show()

                }

                override fun onException(exception: Exception) {
                    Log.e("SplashActivity", "Exception: ", exception)
                    Toast.makeText(this@SplashActivity, "Exception occurred", Toast.LENGTH_SHORT)
                        .show()
                }
            })

    }


    private fun login_open() {
        val intent = Intent(this, LoginActivity::class.java)
        startActivity(intent)
        AnimationHelper.applySlideZoomTransition(this)
        finish()
    }


}